#ifndef __X4D_MINIBLT__
#define __X4D_MINIBLT__

#include	"x4d_filter.h"

//----------------------------------------------------------------------------------------
// interface function types
//----------------------------------------------------------------------------------------
typedef	void	*BLT_MALLOC( LONG size );
typedef	LONG	BLT_MFREE( void *addr );

typedef void	*BLT_FUNC( struct BLT_PARAM *p, 
												 LONG src_x1, LONG src_y1, LONG src_x2, LONG src_y2,
												 LONG dst_x1, LONG dst_y1, LONG dst_x2, LONG dst_y2 );

typedef void	BLT_LINE( struct BLT_PARAM *p );

//----------------------------------------------------------------------------------------
// interface structures
//----------------------------------------------------------------------------------------
struct BLT_MEM
{
	BLT_MALLOC	*malloc;
	BLT_MFREE	*mfree;
};

struct BLT_PARAM
{
// rects
	const RECT32	*src_rect;
	const RECT32	*dst_rect;

// bitmaps
	BM_TILE	src;
	BM_TILE	dst;

// misc.
	const BLT_MEM	*bfn;
	LONG	wr_mode;

// variables for single line output
	LONG	mid_cnt;
	ULONG	start_mask;
	ULONG	end_mask;
	void	*src_start_addr;
	void	*dst_start_addr;
	LONG	src_offset;
	LONG	dst_offset;
};

//----------------------------------------------------------------------------------------
// supported transfer modes
#define	T_LOGIC_COPY	0
#define	T_PREPARELINE	0x80000000L

// error codes
#define	BLT_OK						0
#define	BLT_MEM_ERR				-1
#define	BLT_PX_FORMAT_ERR	-2

//----------------------------------------------------------------------------------------
// functions
//----------------------------------------------------------------------------------------
extern LONG			blt_init( BLT_PARAM *p, BLT_MEM *bfn, LONG mode );
extern void			blt_reset( BLT_PARAM *p, BLT_MEM *bfn );
extern BLT_LINE	*bitblt( BLT_PARAM *p, LONG src_x1, LONG src_y1, LONG dummy_x, LONG dummy_y, LONG dst_x1, LONG dst_y1, LONG dst_x2, LONG dst_y2 );
extern void			bltline_incdst( BLT_PARAM *p, BLT_LINE *fn );

#endif














